unit Unit1;

interface

uses
  Forms, Dialogs, StdCtrls, Buttons, Trlware, ExtCtrls, Menus, 
  TrlKey, Controls, Classes, Graphics, TrialMon;

type
  TForm1 = class(TForm)
    bbtnShowCode: TBitBtn;
    editCompanyName: TEdit;
    cboxProductCode: TComboBox;
    bbtnExit: TBitBtn;
    editSystemID: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label6: TLabel;
    editRegistrationCode: TEdit;
    Bevel1: TBevel;
    Timer1: TTimer;
    PopupMenu1: TPopupMenu;
    Delete1: TMenuItem;
    bbtnEnterCode: TBitBtn;
    Panel1: TPanel;
    Timer2: TTimer;
    TrialMonitor1: TTrialMonitor;
    procedure bbtnShowCodeClick(Sender: TObject);
    procedure cboxProductCodeChange(Sender: TObject);
    procedure bbtnExitClick(Sender: TObject);
    procedure editCompanyNameChange(Sender: TObject);
    procedure TrialMonitor1CodePass(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure TimerAction(var Timer: TTimer; clColor: TColor);
    procedure cboxProductCodeDropDown(Sender: TObject);
    procedure cboxProductCodeExit(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure EnterCodeClick(Sender: TObject);
    procedure TrialMonitor1CodeFail(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  count: integer;

implementation

uses unit2;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
 count := 0
end;

procedure TForm1.bbtnShowCodeClick(Sender: TObject);
begin
 with TrialMonitor1 do
  begin
   SystemID := editSystemID.Text;
   UserName := editCompanyName.Text;
   UserCode := editRegistrationCode.Text;
   ProdCode := cboxProductCode.Text;
   Panel1.Caption := DecodeCode
  end;
 bbtnEnterCode.Enabled := True
end;

procedure TForm1.cboxProductCodeChange(Sender: TObject);
begin
 Panel1.Caption := '0000000000000000'
end;

procedure TForm1.bbtnExitClick(Sender: TObject);
begin
 Close
end;

procedure TForm1.editCompanyNameChange(Sender: TObject);
begin
 bbtnShowCode.Enabled := (length(editSystemID.Text)*length(editCompanyName.Text) > 0);
 if bbtnShowCode.Enabled then
  Panel1.Caption := 'Click Show Code for Registration Code.'
end;

procedure TForm1.TrialMonitor1CodePass(Sender: TObject);
begin
 MessageDlg('Thank you '+editCompanyName.Text+#10#13+'For supporting '+TrialMonitor1.ApplicationName+'.',mtInformation,[mbOK],0);
 Timer1.Enabled := True;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
 TimerAction(Timer1,clGreen)
end;

procedure TForm1.Timer2Timer(Sender: TObject);
begin
 TimerAction(Timer2,clRed)
end;

procedure TForm1.TimerAction(var Timer: TTimer; clColor: TColor);
begin
 inc(count);
 if (count < 15) then                       // flash for 15 seconds
  begin
   if ((count mod 2) = 0) then
    editRegistrationCode.Color := clColor      //count is even
   else
    editRegistrationCode.Color := clWindow   //count is odd
  end
 else
  begin
   Timer.Enabled := False;
   editRegistrationCode.Color := clWindow;   //count is odd
   count := 0
  end
end;

procedure TForm1.cboxProductCodeDropDown(Sender: TObject);
begin
 try
  cboxProductCode.Items.LoadFromFile('products.txt')
 except
  MessageDlg('There are no items in the list.',mtInformation,[mbOK],0)
 end
end;

procedure TForm1.cboxProductCodeExit(Sender: TObject);
begin
 with cboxProductCode do
  if (Items.IndexOf(Text) < 0) and (Text <> 'Select Product') then
   begin
    Items.Add(Text);
    Items.SaveToFile('products.txt')
   end;
end;

procedure TForm1.Delete1Click(Sender: TObject);
begin
 with cboxProductCode do
  begin
   Items.Delete(Items.IndexOf(Text));
   Items.SaveToFile('products.txt');
   Text := 'Select Product'
  end;
end;

procedure TForm1.EnterCodeClick(Sender: TObject);
var dlg: TForm2;
begin
 dlg := TForm2.Create(nil);
 dlg.TrialFormLink1.UserNameEdit.Text := editCompanyName.Text;
 dlg.TrialFormLink1.UserRegCodeEdit.Text := editRegistrationCode.Text;  //read only
 TrialMonitor1.SystemID := editSystemID.Text;
 TrialMonitor1.NewRegistration(dlg.TrialFormLink1);       //process this information
 editCompanyName.Text := TrialMonitor1.UserName;         //recieve the new information
 editRegistrationCode.Text := TrialMonitor1.UserCode;    //recieve the new informatin
 dlg.Free
end;

procedure TForm1.TrialMonitor1CodeFail(Sender: TObject);
begin
 MessageDlg('Sorry '+editCompanyName.Text+#10#13+'This code is incorrect.',mtError,[mbOK],0);
 Timer2.Enabled := True;
end;

end.
  